# Base client
from ....base import OpenAI_Image_Client

# Mixin
from ....mixins import Image_Context_Manager_Mixin

# Typing
from ....enums import IMAGE_RESPONSE_FORMAT, IMAGE_SIZE
from typing import List

class URL_Image_Client(OpenAI_Image_Client, Image_Context_Manager_Mixin):
    """ Generate images from a prompt and return a URL to the image """

    def __init__(self, pre_prompt_context:List[str] = None, post_prompt_context:List[str] = None, api_key: str = None, max_retries=3, ms_between_retries=500, default_size:IMAGE_SIZE = None, 
                    default_number_of_images:int=1, default_response_format:str=None) -> None:
        
        super().__init__(api_key, max_retries, ms_between_retries, default_size, default_number_of_images, default_response_format)
        Image_Context_Manager_Mixin.__init__(self, pre_prompt_context=pre_prompt_context, post_prompt_context=post_prompt_context)


    def run_prompt(self, prompt:str, number_of_images:int=None, size:IMAGE_SIZE=None):
        """ Sends a prompt to OpenAI to be generated by DALLE. You can specify the 
            number of images to generate and the dimensions of the image.
             
            If more than one image should be generated, this method will return a list of URLs 
            or b64 JSON for each image. 
        """

        # Allow the number_of_images to generate and image size to be specified per call, 
        # but fall back on defaults
        number_of_images = number_of_images or self._number_of_images
        size = self._check_size(size or self._size)

        result = self._api.create(prompt=self.get_prompt_with_context(prompt), n=number_of_images, size=size, response_format=self._response_format)

        return self.process_response(number_of_images, result)


class B64_JSON_Image_Client(URL_Image_Client):
    """ Generate images from a prompt and return the image in b64 JSON"""

    _response_format = IMAGE_RESPONSE_FORMAT.B64_JSON
